require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Agriculture"

-- Contribute Mechanics-specific tooltip lines
ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    if lvl >= 3 then
        ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
        ctx.add(ST.getText("IGUI_DST_Agriculture_val_HoverCrop"))
    end
    if lvl >= 4 then
        ctx.add(ST.getText("IGUI_DST_Agriculture_val_WaterLevel"))
    end
    if lvl >= 6 then
        ctx.add(ST.getText("IGUI_DST_Agriculture_val_NextPhase"))
    end
    if lvl >= 10 then
        ctx.add(ST.getText("IGUI_DST_Agriculture_val_GrowingSeasons"))
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)